# Product Code Validation — Exception Handling Demo

## 1) What the program does

- Repeatedly prompts the user for a **product code** until they enter `XXX` (case-insensitive) to quit.
- A code is **valid** if it has **exactly 5 characters**: the first **4 are digits** (the _area_), and the **5th is a letter** (the _city_).
- Among valid codes, a code is **banned** if `area >= 2000` **and** `city == 'B'`.
- The program keeps track of **valid** and **banned** codes and prints the totals at the end.

## 2) Exceptions handled (why and when)

- **NumberFormatException** – thrown when converting the first 4 characters to an integer fails
  _When it triggers?_ the area part contains a non-digit (e.g., `12A4X`).
  _Outcome:_ informs the user that area info must be numeric instead of crashing the program.
- **StringIndexOutOfBoundsException** – thrown when the input is too short/long to safely slice the first 4 chars or access the 5th char
  _When it triggers?_ input length < 5 (e.g., `12B`) or slicing/char access is invalid.
  _Outcome:_ informs the user that a code must be _4 digits followed by 1 character_.

_(Both exceptions are caught so the loop continues and the user can try again.)_
